import os
import sys
import gzip

from Bio.Seq import reverse_complement
from Bio import SeqIO

library = sys.argv[1]

sequences = {}
filename = "seqlist.fa"
print("Reading %s" % filename)
handle = open(filename)
records = SeqIO.parse(handle, "fasta")
for i, record in enumerate(records):
    sequence = str(record.seq)
    assert record.id == "seq_%08d" % i
    sequences[sequence] = i
handle.close()

filename = "%s.fa" % library
handle = open(filename)
records = SeqIO.parse(handle, "fasta")
filename = "%s.index.txt" % library
print("Writing", filename)
output = open(filename, 'w')
for record in records:
    name = record.id
    sequence = record.seq
    key = str(sequence)
    value = sequences[key]
    line = "%s\tseq_%08d\n" % (name, value)
    output.write(line)
output.close()
handle.close()
print("Done")
